/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.GuiHandler;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.AssetManager;
import com.lycanitesmobs.client.gui.BaseScreen;
import com.lycanitesmobs.client.gui.beastiary.CreaturesBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.ElementsBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.IndexBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.PetsBeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.SummoningBeastiaryScreen;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.core.entity.AgeableCreatureEntity;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.CreatureInfo;
import java.io.IOException;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public abstract class BeastiaryScreen
extends BaseScreen {
    static int OPENED_GUI_SCALE;
    static boolean GUI_ACTIVE;
    public EntityPlayer player;
    public ExtendedPlayer playerExt;
    public EntityLivingBase creaturePreviewEntity;
    public float creaturePreviewTicks = 0.0f;
    public ScaledResolution scaledResolution;
    public int centerX;
    public int centerY;
    public int windowWidth;
    public int windowHeight;
    public int halfX;
    public int halfY;
    public int windowX;
    public int windowY;
    public int colLeftX;
    public int colLeftY;
    public int colLeftWidth;
    public int colLeftHeight;
    public int colLeftCenterX;
    public int colLeftCenterY;
    public int colRightX;
    public int colRightY;
    public int colRightWidth;
    public int colRightHeight;
    public int colRightCenterX;
    public int colRightCenterY;

    public BeastiaryScreen(EntityPlayer player) {
        this.player = player;
        this.playerExt = ExtendedPlayer.getForPlayer(player);
        this.field_146297_k = Minecraft.func_71410_x();
        if (this.field_146297_k.field_71474_y.field_74335_Z != 2 || GUI_ACTIVE) {
            OPENED_GUI_SCALE = this.field_146297_k.field_71474_y.field_74335_Z;
            this.field_146297_k.field_71474_y.func_74306_a(GameSettings.Options.GUI_SCALE, 2 - OPENED_GUI_SCALE);
        } else {
            GUI_ACTIVE = true;
        }
    }

    public void func_146281_b() {
        if (this.field_146297_k.field_71474_y.field_74335_Z == 2 && !GUI_ACTIVE) {
            this.field_146297_k.field_71474_y.func_74306_a(GameSettings.Options.GUI_SCALE, OPENED_GUI_SCALE - 2);
        }
        GUI_ACTIVE = false;
        super.func_146281_b();
    }

    public String getTitle() {
        return "Beastiary";
    }

    public boolean func_73868_f() {
        return false;
    }

    public int getScaledX(float x) {
        float scaledWidth;
        if (this.scaledResolution == null) {
            this.scaledResolution = new ScaledResolution(this.field_146297_k);
        }
        float targetAspect = 0.5625f;
        float scaledHeight = this.scaledResolution.func_78328_b();
        float currentAspect = scaledHeight * x / ((scaledWidth = (float)this.scaledResolution.func_78326_a()) * x);
        if (currentAspect < targetAspect) {
            scaledWidth = scaledHeight + scaledHeight * targetAspect;
        } else if (currentAspect > targetAspect) {
            scaledHeight = scaledWidth + scaledWidth * targetAspect;
        }
        float guiWidth = scaledWidth * x;
        return Math.round(Math.max(x, guiWidth));
    }

    public int getScaledY(float y) {
        float baseHeight = Math.round((float)this.getScaledX(y) * 0.5625f);
        return Math.round(baseHeight * y);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.scaledResolution == null) {
            this.scaledResolution = new ScaledResolution(this.field_146297_k);
        }
        this.field_73735_i = -1000.0f;
        this.windowWidth = this.getScaledX(0.95f);
        this.windowHeight = this.getScaledY(0.95f);
        this.halfX = this.windowWidth / 2;
        this.halfY = this.windowHeight / 2;
        this.windowX = this.field_146294_l / 2 - this.windowWidth / 2;
        this.windowY = this.field_146295_m / 2 - this.windowHeight / 2;
        this.centerX = this.windowX + this.windowWidth / 2;
        this.centerY = this.windowY + this.windowHeight / 2;
        this.colLeftX = this.windowX + this.getScaledX(0.041666668f);
        this.colLeftY = this.windowY + this.getScaledY(0.42592594f);
        this.colLeftWidth = this.getScaledX(0.16666667f);
        this.colLeftHeight = this.getScaledX(0.35185185f);
        this.colLeftCenterX = this.colLeftX + Math.round(this.colLeftWidth / 2);
        this.colLeftCenterY = this.colLeftY + Math.round(this.colLeftHeight / 2);
        this.colRightX = this.windowX + this.getScaledX(0.25f);
        this.colRightY = this.windowY + this.getScaledY(0.3888889f);
        this.colRightWidth = this.getScaledX(0.65625f);
        this.colRightHeight = this.getScaledX(0.37037036f);
        this.colRightCenterX = this.colRightX + Math.round(this.colRightWidth / 2);
        this.colRightCenterY = this.colRightY + Math.round(this.colRightHeight / 2);
        this.field_146292_n.clear();
        this.initControls();
    }

    protected void initControls() {
        int menuPadding = 6;
        int menuX = this.centerX - Math.round((float)this.windowWidth / 2.0f) + menuPadding;
        int menuY = this.windowY + menuPadding;
        int menuWidth = this.windowWidth - menuPadding * 2;
        int buttonCount = 5;
        int buttonPadding = 2;
        int buttonX = menuX + buttonPadding;
        int buttonWidth = Math.round(menuWidth / buttonCount) - buttonPadding * 2;
        int buttonWidthPadded = buttonWidth + buttonPadding * 2;
        int buttonHeight = 20;
        GuiButton button = new GuiButton((int)GuiHandler.Beastiary.INDEX.id, buttonX + buttonWidthPadded * this.field_146292_n.size(), menuY, buttonWidth, buttonHeight, LanguageManager.translate("gui.beastiary.index.title"));
        this.field_146292_n.add(button);
        button = new GuiButton((int)GuiHandler.Beastiary.CREATURES.id, buttonX + buttonWidthPadded * this.field_146292_n.size(), menuY, buttonWidth, buttonHeight, LanguageManager.translate("gui.beastiary.creatures"));
        this.field_146292_n.add(button);
        button = new GuiButton((int)GuiHandler.Beastiary.PETS.id, buttonX + buttonWidthPadded * this.field_146292_n.size(), menuY, buttonWidth, buttonHeight, LanguageManager.translate("gui.beastiary.pets"));
        this.field_146292_n.add(button);
        button = new GuiButton((int)GuiHandler.Beastiary.SUMMONING.id, buttonX + buttonWidthPadded * this.field_146292_n.size(), menuY, buttonWidth, buttonHeight, LanguageManager.translate("gui.beastiary.summoning"));
        this.field_146292_n.add(button);
        button = new GuiButton((int)GuiHandler.Beastiary.ELEMENTS.id, buttonX + buttonWidthPadded * this.field_146292_n.size(), menuY, buttonWidth, buttonHeight, LanguageManager.translate("gui.beastiary.elements"));
        this.field_146292_n.add(button);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.drawBackground(mouseX, mouseY, partialTicks);
        this.drawForeground(mouseX, mouseY, partialTicks);
        this.updateControls(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    public void drawBackground(int mouseX, int mouseY, float partialTicks) {
        this.drawTexture(AssetManager.getTexture("GUIBeastiaryBackground"), this.windowX, this.windowY, this.field_73735_i, 1.0f, 1.0f, this.windowWidth, this.windowHeight);
    }

    protected void updateControls(int mouseX, int mouseY, float partialTicks) {
        for (GuiButton button : this.field_146292_n) {
            button.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
        }
    }

    public void drawForeground(int mouseX, int mouseY, float partialTicks) {
        String title = "\u00a7l\u00a7n" + this.getTitle();
        float width = this.getFontRenderer().func_78256_a(title);
        this.getFontRenderer().func_175065_a(title, (float)(this.colRightCenterX - Math.round(width / 2.0f)), (float)this.colRightY, 0xFFFFFF, true);
    }

    protected void func_146284_a(GuiButton guiButton) throws IOException {
        if (guiButton != null) {
            if (guiButton.field_146127_k == GuiHandler.Beastiary.INDEX.id) {
                IndexBeastiaryScreen.openToPlayer(this.player);
            }
            if (guiButton.field_146127_k == GuiHandler.Beastiary.CREATURES.id) {
                CreaturesBeastiaryScreen.openToPlayer(this.player);
            }
            if (guiButton.field_146127_k == GuiHandler.Beastiary.PETS.id) {
                PetsBeastiaryScreen.openToPlayer(this.player);
            }
            if (guiButton.field_146127_k == GuiHandler.Beastiary.SUMMONING.id) {
                SummoningBeastiaryScreen.openToPlayer(this.player);
            }
            if (guiButton.field_146127_k == GuiHandler.Beastiary.ELEMENTS.id) {
                ElementsBeastiaryScreen.openToPlayer(this.player);
            }
        }
        super.func_146284_a(guiButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1 || keyCode == this.field_146297_k.field_71474_y.field_151445_Q.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void openURI(URI uri) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, uri);
        }
        catch (Throwable throwable) {
            LycanitesMobs.logWarning("", "Unable to open link: " + uri.toString());
        }
    }

    public void drawLevel(CreatureInfo creatureInfo, ResourceLocation texture, int x, int y) {
        int level = creatureInfo.summonCost;
        if (level <= 10) {
            this.drawBar(texture, x, y, 0.0f, 9.0f, 9.0f, level, 10);
        }
    }

    public void renderCreature(CreatureInfo creatureInfo, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (creatureInfo == null) {
            this.creaturePreviewEntity = null;
            return;
        }
        try {
            boolean subspeciesMatch = true;
            if (this.creaturePreviewEntity instanceof BaseCreatureEntity) {
                boolean bl = subspeciesMatch = ((BaseCreatureEntity)this.creaturePreviewEntity).getSubspeciesIndex() == this.getDisplaySubspecies(creatureInfo);
                if (subspeciesMatch) {
                    boolean bl2 = subspeciesMatch = ((BaseCreatureEntity)this.creaturePreviewEntity).getVariantIndex() == this.getDisplayVariant(creatureInfo);
                }
            }
            if (this.creaturePreviewEntity == null || this.creaturePreviewEntity.getClass() != creatureInfo.entityClass || !subspeciesMatch) {
                this.creaturePreviewEntity = (EntityLivingBase)creatureInfo.entityClass.getConstructor(World.class).newInstance(this.player.func_130014_f_());
                this.creaturePreviewEntity.field_70122_E = true;
                if (this.creaturePreviewEntity instanceof BaseCreatureEntity) {
                    ((BaseCreatureEntity)this.creaturePreviewEntity).setSubspecies(this.getDisplaySubspecies(creatureInfo));
                    ((BaseCreatureEntity)this.creaturePreviewEntity).setVariant(this.getDisplayVariant(creatureInfo));
                    ((BaseCreatureEntity)this.creaturePreviewEntity).updateSize();
                }
                if (this.creaturePreviewEntity instanceof AgeableCreatureEntity) {
                    ((AgeableCreatureEntity)this.creaturePreviewEntity).setGrowingAge(0);
                }
                this.onCreateDisplayEntity(creatureInfo, this.creaturePreviewEntity);
                this.playCreatureSelectSound(creatureInfo);
            }
            if (this.creaturePreviewEntity != null) {
                int creatureSize = 70;
                float creatureWidth = this.creaturePreviewEntity.field_70130_N;
                float creatureHeight = this.creaturePreviewEntity.field_70131_O;
                int scale = Math.round(1.8f / Math.max(creatureWidth, creatureHeight) * (float)creatureSize);
                int posX = x;
                int posY = y + 32 + creatureSize;
                float lookX = (float)posX - (float)mouseX;
                float lookY = (float)posY - (float)mouseY;
                this.creaturePreviewTicks += partialTicks;
                if (this.creaturePreviewEntity instanceof BaseCreatureEntity) {
                    BaseCreatureEntity previewCreatureBase = (BaseCreatureEntity)this.creaturePreviewEntity;
                    previewCreatureBase.onlyRenderTicks = this.creaturePreviewTicks;
                }
                GlStateManager.func_179142_g();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)posX, (float)posY, (float)-500.0f);
                GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                float f = this.creaturePreviewEntity.field_70761_aq;
                float f1 = this.creaturePreviewEntity.field_70177_z;
                float f2 = this.creaturePreviewEntity.field_70125_A;
                float f3 = this.creaturePreviewEntity.field_70758_at;
                float f4 = this.creaturePreviewEntity.field_70759_as;
                GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                RenderHelper.func_74519_b();
                GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-((float)Math.atan(lookY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                this.creaturePreviewEntity.field_70761_aq = (float)Math.atan(lookX / 40.0f) * 20.0f;
                this.creaturePreviewEntity.field_70177_z = (float)Math.atan(lookX / 40.0f) * 40.0f;
                this.creaturePreviewEntity.field_70125_A = -((float)Math.atan(lookY / 40.0f)) * 20.0f;
                this.creaturePreviewEntity.field_70759_as = this.creaturePreviewEntity.field_70177_z;
                this.creaturePreviewEntity.field_70758_at = this.creaturePreviewEntity.field_70177_z;
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
                RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
                rendermanager.func_178631_a(180.0f);
                rendermanager.func_178633_a(false);
                rendermanager.func_188391_a((Entity)this.creaturePreviewEntity, 0.0, 0.0, 0.0, 0.0f, 1.0f, true);
                rendermanager.func_178633_a(true);
                this.creaturePreviewEntity.field_70761_aq = f;
                this.creaturePreviewEntity.field_70177_z = f1;
                this.creaturePreviewEntity.field_70125_A = f2;
                this.creaturePreviewEntity.field_70758_at = f3;
                this.creaturePreviewEntity.field_70759_as = f4;
                GlStateManager.func_179121_F();
                RenderHelper.func_74518_a();
                GlStateManager.func_179101_C();
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
                GlStateManager.func_179090_x();
                GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "An exception occurred when trying to preview a creature in the Beastiary.");
            e.printStackTrace();
        }
    }

    public int getDisplaySubspecies(CreatureInfo creatureInfo) {
        return this.playerExt.selectedSubspecies;
    }

    public int getDisplayVariant(CreatureInfo creatureInfo) {
        return this.playerExt.selectedVariant;
    }

    public void playCreatureSelectSound(CreatureInfo creatureInfo) {
        String soundSuffix = "";
        if (creatureInfo.getSubspecies((int)this.playerExt.selectedSubspecies).name != null) {
            soundSuffix = soundSuffix + "." + creatureInfo.getSubspecies((int)this.playerExt.selectedSubspecies).name;
        }
        SoundEvent soundEvent = AssetManager.getSound(creatureInfo.getName() + soundSuffix + "_say");
        this.player.func_130014_f_().func_184148_a(this.player, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, soundEvent, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public void onCreateDisplayEntity(CreatureInfo creatureInfo, EntityLivingBase entity) {
    }
}

